/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.java;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.sampler.AbstractSampler;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.java.JavaDataAggregator;
import me.lucko.spark.common.sampler.java.SimpleDataAggregator;
import me.lucko.spark.common.sampler.java.TickedDataAggregator;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.sampler.source.ClassSourceLookup;
import me.lucko.spark.common.sampler.window.ProfilingWindowUtils;
import me.lucko.spark.common.sampler.window.WindowStatisticsCollector;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.proto.SparkSamplerProtos;

public class JavaSampler
extends AbstractSampler
implements Runnable {
    private static final AtomicInteger THREAD_ID = new AtomicInteger(0);
    private final ScheduledExecutorService workerPool = Executors.newScheduledThreadPool(6, new ThreadFactoryBuilder().setNameFormat("spark-worker-" + THREAD_ID.getAndIncrement() + "-%d").build());
    private ScheduledFuture<?> task;
    private final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private final JavaDataAggregator dataAggregator;
    private final AtomicInteger lastWindow = new AtomicInteger();

    public JavaSampler(SparkPlatform platform, int interval, ThreadDumper threadDumper, ThreadGrouper threadGrouper, long endTime, boolean ignoreSleeping, boolean ignoreNative) {
        super(platform, interval, threadDumper, endTime);
        this.dataAggregator = new SimpleDataAggregator(this.workerPool, threadGrouper, interval, ignoreSleeping, ignoreNative);
    }

    public JavaSampler(SparkPlatform platform, int interval, ThreadDumper threadDumper, ThreadGrouper threadGrouper, long endTime, boolean ignoreSleeping, boolean ignoreNative, TickHook tickHook, int tickLengthThreshold) {
        super(platform, interval, threadDumper, endTime);
        this.dataAggregator = new TickedDataAggregator(this.workerPool, threadGrouper, interval, ignoreSleeping, ignoreNative, tickHook, tickLengthThreshold);
    }

    @Override
    public void start() {
        super.start();
        TickHook tickHook = this.platform.getTickHook();
        if (tickHook != null) {
            if (this.dataAggregator instanceof TickedDataAggregator) {
                WindowStatisticsCollector.ExplicitTickCounter counter = this.windowStatisticsCollector.startCountingTicksExplicit(tickHook);
                ((TickedDataAggregator)this.dataAggregator).setTickCounter(counter);
            } else {
                this.windowStatisticsCollector.startCountingTicks(tickHook);
            }
        }
        this.task = this.workerPool.scheduleAtFixedRate(this, 0L, this.interval, TimeUnit.MICROSECONDS);
    }

    @Override
    public void stop() {
        super.stop();
        this.task.cancel(false);
        this.windowStatisticsCollector.measureNow(this.lastWindow.get());
    }

    @Override
    public void run() {
        try {
            long time = System.currentTimeMillis();
            if (this.autoEndTime != -1L && this.autoEndTime <= time) {
                this.stop();
                this.future.complete(this);
                return;
            }
            int window = ProfilingWindowUtils.unixMillisToWindow(time);
            ThreadInfo[] threadDumps = this.threadDumper.dumpThreads(this.threadBean);
            this.workerPool.execute(new InsertDataTask(threadDumps, window));
        }
        catch (Throwable t) {
            this.stop();
            this.future.completeExceptionally(t);
        }
    }

    @Override
    public SparkSamplerProtos.SamplerData toProto(SparkPlatform platform, CommandSender creator, String comment, MergeMode mergeMode, ClassSourceLookup classSourceLookup) {
        SparkSamplerProtos.SamplerData.Builder proto = SparkSamplerProtos.SamplerData.newBuilder();
        this.writeMetadataToProto(proto, platform, creator, comment, this.dataAggregator);
        this.writeDataToProto(proto, this.dataAggregator, mergeMode, classSourceLookup);
        return (SparkSamplerProtos.SamplerData)proto.build();
    }

    private final class InsertDataTask
    implements Runnable {
        private final ThreadInfo[] threadDumps;
        private final int window;

        InsertDataTask(ThreadInfo[] threadDumps, int window) {
            this.threadDumps = threadDumps;
            this.window = window;
        }

        @Override
        public void run() {
            for (ThreadInfo threadInfo : this.threadDumps) {
                if (threadInfo.getThreadName() == null || threadInfo.getStackTrace() == null) continue;
                JavaSampler.this.dataAggregator.insertData(threadInfo, this.window);
            }
            int previousWindow = JavaSampler.this.lastWindow.getAndSet(this.window);
            if (previousWindow != 0 && previousWindow != this.window) {
                JavaSampler.this.windowStatisticsCollector.measureNow(previousWindow);
            }
        }
    }
}

